import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const images = [
    '/images/drawing-1.jpg',
    '/images/drawing-2.jpg',
    '/images/drawing-3.jpg',
    '/images/drawing-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-creative">
      <div className="slider-wrapper-creative">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentIndex}
            className="slide-creative"
            initial={{ opacity: 0, scale: 1.1 }}
            animate={{ opacity: 1, scale: 1 }}
            exit={{ opacity: 0, scale: 0.9 }}
            transition={{ duration: 0.6 }}
            style={{ backgroundImage: `url(${images[currentIndex]})` }}
          >
            <div className="slide-overlay-creative"></div>
          </motion.div>
        </AnimatePresence>

        <motion.button 
          className="slider-btn-creative slider-btn-prev-creative" 
          onClick={goToPrevious}
          whileHover={{ scale: 1.1 }}
          whileTap={{ scale: 0.9 }}
        >
          <ChevronLeft size={28} strokeWidth={2.5} />
        </motion.button>
        <motion.button 
          className="slider-btn-creative slider-btn-next-creative" 
          onClick={goToNext}
          whileHover={{ scale: 1.1 }}
          whileTap={{ scale: 0.9 }}
        >
          <ChevronRight size={28} strokeWidth={2.5} />
        </motion.button>

        <div className="slider-dots-creative">
          {images.map((_, index) => (
            <motion.button
              key={index}
              className={`dot-creative ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
              whileHover={{ scale: 1.2 }}
              whileTap={{ scale: 0.9 }}
              aria-label={`Go to slide ${index + 1}`}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

